// Copyright (c) 2015 Nuxi, https://nuxi.nl/
//
// SPDX-License-Identifier: BSD-2-Clause

#include <dirent.h>
#include <stdlib.h>

#include "dirent_impl.h"

int fdclosedir(DIR *dirp) {
  int fd = dirp->fd;
#ifdef __wasilibc_use_wasip2
  if (dirp->stream.__handle != 0)
    filesystem_directory_entry_stream_drop_own(dirp->stream);
#else
  free(dirp->buffer);
#endif
  free(dirp->dirent);
  free(dirp);
  return fd;
}
