macro(assert_var_defined varname)
    if(NOT DEFINED ${varname})
        message(SEND_ERROR "${varname} is not defined.")
    endif()
endmacro()

macro(assert_vars_strequal varname exp_varname)
    if(ARGC LESS 3 OR NOT "${ARGV2}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    if(NOT ${varname} STREQUAL ${exp_varname})
        message(SEND_ERROR "${varname} is '${${varname}}', expecting '${${exp_varname}}'.")
    endif()
endmacro()

macro(assert_var_str_value varname value)
    if(ARGC LESS 3 OR NOT "${ARGV2}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    set(_value_var "${value}")
    if(NOT ${varname} STREQUAL _value_var)
        message(SEND_ERROR "${varname} is '${${varname}}', expecting '${value}'.")
    endif()
endmacro()

macro(assert_var_num_value varname value)
    if(ARGC LESS 3 OR NOT "${ARGV2}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    set(_value_var "${value}")
    if(NOT ${varname} EQUAL _value_var)
        message(SEND_ERROR "${varname} is '${${varname}}', expecting '${value}'.")
    endif()
endmacro()

macro(assert_var_bool_value varname value)
    if(ARGC LESS 3 OR NOT "${ARGV2}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    if(${value} AND NOT ${varname})
        message(FATAL_ERROR "${varname} was FALSE")
    elseif(${varname} AND NOT ${value})
        message(FATAL_ERROR "${varname} was TRUE")
    endif()
endmacro()

macro(assert_var_relative_path varname)
    if(ARGC LESS 2 OR NOT "${ARGV1}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    if(DEFINED ${varname} AND IS_ABSOLUTE "${${varname}}")
        message(SEND_ERROR "${varname} (${${varname}}) should be a relative path, but is absolute.")
    endif()
endmacro()

macro(assert_var_absolute_path varname)
    if(ARGC LESS 2 OR NOT "${ARGV1}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    if(DEFINED ${varname} AND NOT IS_ABSOLUTE "${${varname}}")
        message(SEND_ERROR "${varname} (${${varname}}) should be an absolute path, but is relative.")
    endif()
endmacro()

function(assert_vars_setequal varname exp_varname)
    if(ARGC LESS 3 OR NOT "${ARGV2}" STREQUAL "ALLOW_UNDEFINED")
        assert_var_defined(${varname})
    endif()
    # need real variables
    set(list1 "${${varname}}")
    set(list2 "${${exp_varname}}")
    list(LENGTH list1 list1_len)
    list(LENGTH list2 list2_len)
    set(same_els FALSE)
    if(list1_len EQUAL list2_len)
        set(same_els TRUE)
        foreach(item ${list1})
            list(FIND list2 "${item}" pos)
            if(pos EQUAL "-1")
                set(same_els FALSE)
                break()
            else()
                # deal nicely with duplicates
                list(REMOVE_AT list2 "${pos}")
            endif()
        endforeach()
    endif()
    if(NOT same_els)
        message(SEND_ERROR "${varname} is '${${varname}}', expecting '${${exp_varname}}'.")
    endif()
endfunction()

